<?php

require_once('MasterModeConfiguration.php');
require_once('WebConsoleSwitch.php');

function generate_sc_cfg($xml_path, $sc_id) {
    $sc_cfg = new SimpleXMLElement("<configuration></configuration>");
    $sc_id_element = $sc_cfg->addChild('my_sc_id', $sc_id);

	$dom = new DOMDocument('1.0');
	$dom->preserveWhiteSpace = false;
	$dom->formatOutput = true;
	$dom->loadXML($sc_cfg->saveXML());
	$output_xml = $dom->saveXML();

    file_put_contents($xml_path, $output_xml);
}

function add_new_cluster($argv) {
    global $DTASCFG_XML_FILE, $BACKEND;
    $cluster_cfg_path = dirname(__FILE__) . "/cluster_dtascfg.xml";
    //this mapping would be evaluated recursively
    $xml_db_mapping = array(
                            "/configuration/esxi/ip",
                            "/configuration/esxi/username",
                            "/configuration/esxi/password",
                            "/configuration/sandbox_controller/image_path",
                            "/configuration/sandbox_controller/image_path_vix",
                            "/configuration/sandbox_controller/prefix",
                            "/configuration/sandbox_controller/dhcp",
                            "/configuration/sandbox_controller/ip",
                            "/configuration/sandbox_controller/netmask",
                            "/configuration/sandbox_controller/gateway",
                            "/configuration/sandbox_controller/dns",
                            "/configuration/sandbox_controller/admin_password",
                            "/configuration/sandbox_controller/admin_username",
                            "/configuration/nat/dhcp",
                            "/configuration/nat/ip",
                            "/configuration/nat/netmask",
                            "/configuration/nat/gateway",
                            "/configuration/nat/dns",
                            "/configuration/nat/hostname",
                            "/configuration/image_type",
                            "/configuration/management_server/ip",
                            "/configuration/management_server/admin_username",
                            "/configuration/management_server/admin_password",
                            "/configuration/management_server/prefix",
                            "/configuration/db/password",
                            "/configuration/db/username",
                        );

    $cluster_ref_cfg_list = array(
        "/configuration/esxi/ip" => "/configuration/management_server/ip",
        "/configuration/sandbox_controller/ip" => "/configuration/management_server/ip",
    );

    /* check number of arguments */
	if(count($argv) != 6) {
	    echo "Usage: add_new_cluster CLUSTER_NAME ESXI_IP ESXI_USERNAME ESXI_PASSWORD MANAGEMENT_SERVER_IMAGE_PATH SANDBOX_CONTROLLER_IMAGE_PATH\n";
        exit(1);
    }

    $cluster_name = $argv[0];
    $esxi_ip = $argv[1];
	$esxi_username = $argv[2];
	$esxi_password = $argv[3];
	$management_server_vmpath = $argv[4];
	$sandbox_controller_vmpath = $argv[5];

	$xml = simplexml_load_file($DTASCFG_XML_FILE);
    $db_host = chop($xml->db->host);
    $db_user = chop($xml->db->username);
    $db_password =  $xml->db->password;
    $sandbox_controller_admin_username = chop($xml->sandbox_controller->admin_username);
	$sandbox_controller_admin_password = $xml->sandbox_controller->admin_password;
	$sandbox_number_for_cluster = chop($xml->sandbox->number);

    if(($db_connect = pg_connect("host=$db_host dbname=dtasdb port=5432 user=$db_user password=$db_password")) == FALSE) {
        echo "Failed to connect to database\n";
        exit(1);
    }

    unset($db_result);
    if(($db_result = pg_query($db_connect, 'SELECT max(sc_id) FROM tb_sc_info')) == FALSE) {
        $err_msg = pg_last_error();
        echo "Failed to get max sc_id from tb_sc_info, error message: $err_msg\n";

        if( $db_connect !== false ) {
            pg_close( $db_connect ) ;
        }

        exit(1);
    }
    $db_result = pg_fetch_array($db_result, null, PGSQL_NUM);
    $sc_id = $db_result[0] + 1;

    $sandbox_controller_prefix = chop($xml->sandbox_controller->prefix);
	$controller_vix_vmpath = get_vm_vixpath($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_prefix);

	start_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_vmpath);

    // Escape variables since then they will be used in command line
    $esxi_username = escapeshellarg($esxi_username);
    $esxi_password = escapeshellarg($esxi_password);
    $sandbox_controller_admin_username = escapeshellarg($sandbox_controller_admin_username);
    $sandbox_controller_admin_password = escapeshellarg($sandbox_controller_admin_password);

	unset($result_array);
	exec("$BACKEND copy_file_from_vm_to_server_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /etc/dtascfg.xml " . $cluster_cfg_path . " 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /bin/cp /etc/dtascfg.xml /etc/dtascfg.xml.backup 2>&1", $result_array, $return_value);
    if($return_value != 0) print_error($result_array, $return_value);


    try {
        $master_mode_config = new MasterModeConfiguration($cluster_cfg_path);
        $master_mode_config->disableSwitchable();
        $master_mode_config->notifyConfigChange();

        $web_console_switch = new WebConsoleSwitch($cluster_cfg_path);
        $web_console_switch->turnOffConsole();
    } catch (Exception $e) {
        debug_print("Caught exception:" . var_export($e, true));
        echo $e->getMessage();
        exit(1);
    }

    try {
        pg_query($db_connect, 'BEGIN WORK');

        if(pg_query_params($db_connect, 'INSERT INTO tb_sc_info (sc_id) VALUES($1)', array($sc_id)) == FALSE) {
            $err_msg = pg_last_error();
            throw new Exception("Failed to insert new sc_id ($sc_id) into tb_sc_info, error message: $err_msg");
        }

    	// insert cluster name to db
    	if(pg_query_params($db_connect, 'INSERT INTO tb_global_setting (key, value) VALUES($1, $2)', array("configuration.cluster_$sc_id.name", $cluster_name)) == FALSE) {
    	    $err_msg = pg_last_error();
            throw new Exception("Failed to insert cluster name ($cluster_name) into tb_global_setting, error message: $err_msg");
        }

    	// insert management image path to db
    	if(pg_query_params($db_connect, 'INSERT INTO tb_global_setting (key, value) VALUES($1, $2)', array("configuration.cluster_$sc_id.management_server.image_path", $management_server_vmpath)) == FALSE) {
    	    $err_msg = pg_last_error();
            throw new Exception("Failed to insert management server image path ($management_server_vmpath) into tb_global_setting, error message: $err_msg");
        }

    	// insert the other cluster configurations to db
        $xml_path_val_list = ConfigUtility::getPathVal($cluster_cfg_path, $xml_db_mapping);
        foreach($cluster_ref_cfg_list as $path => $ref_path) {
            $xml_path_val_list[$path] = $xml_path_val_list[$ref_path];
        }
    	foreach ($xml_path_val_list as $xml_path => $xml_val) {

    	    $db_xml_path = str_replace("/configuration", "/configuration/cluster_$sc_id", $xml_path);
            $db_xml_path = str_replace("/", ".", substr($db_xml_path, 1));

    	    if(pg_query_params($db_connect, 'INSERT INTO tb_global_setting (key, value) VALUES($1, $2)', array($db_xml_path, $xml_val)) == FALSE) {
    	        $err_msg = pg_last_error();
                throw new Exception("Failed to insert cluster configuration ($db_xml_path) into tb_global_setting, error message: $err_msg");
            }
        }

        // update total number of sandboxes
        unset($db_result);
        if(($db_result = pg_query_params($db_connect, 'SELECT value FROM tb_global_setting WHERE key=$1', array("configuration.sandbox.total_number"))) == FALSE) {
            $err_msg = pg_last_error();
            throw new Exception("Failed to select key (configuration.sandbox.total_number) from tb_global_setting, error message: $err_msg");
        }
        $db_result = pg_fetch_array($db_result, null, PGSQL_NUM);

        $total_number = $db_result[0] + $sandbox_number_for_cluster;
        if(pg_query_params($db_connect, 'UPDATE tb_global_setting SET value=$1 WHERE key=$2', array($total_number, "configuration.sandbox.total_number")) == FALSE) {
            $err_msg = pg_last_error();
            throw new Exception("Failed to update key (configuration.sandbox.total_number) to tb_global_setting, error message: $err_msg");
        }

        pg_query($db_connect, 'COMMIT');

        if( $db_connect !== false ) {
            pg_close($db_connect);
        }
    }
    catch(Exception $e) {
        echo "Exception caught: " . $e->getMessage();

        pg_query($db_connect, 'ROLLBACK');

        if( $db_connect !== false ) {
            pg_close($db_connect);
        }

        exit(1);
    }

    generate_sc_cfg(dirname(__FILE__) . "/cluster_sccfg.xml", $sc_id);

    unset($result_array);
    exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/cluster_sccfg.xml /opt/TrendMicro/DTAS/SandboxController/sccfg.xml 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

    disableMasterSwitchableIfNecessary($DTASCFG_XML_FILE);

    unlink($cluster_cfg_path);
    unlink(dirname(__FILE__) . "/cluster_sccfg.xml");

	echo $sc_id;
}

function disableMasterSwitchableIfNecessary($cfg_path)
{
    try{
        $master_mode_config = new MasterModeConfiguration($cfg_path);
        $switchable = $master_mode_config->isSwitchable();
        $master_mode_config->disableSwitchable();
        $master_mode_config->notifyConfigChange();
    }catch (Exception $e) {
        debug_print("Disable master switchable fail," . var_export($e, true));
        echo "Disable master switchable fail, " . $e->getMessage();
        exit(1);
    }
}

class ConfigUtility
{
    protected static function getNodeInfo($node) {
        $node_type = $node->nodeType;
        if($node_type != XML_TEXT_NODE && $node_type != XML_ELEMENT_NODE) return array();
        $node_path = $node->getNodePath();
        if(substr($node_path, -1) == ']') return array();
        //remove the end of string : "\text()"
        $node_path = preg_replace('/\/text\(\)$/', '', $node_path);
        return array($node_path => $node->nodeValue);
    }
    public static function listAllNodePathVal(DomNode $node) {
        if(!$node->hasChildNodes()) return ConfigUtility::getNodeInfo($node);
        $node_path_list = array();
        $child_list = $node->childNodes;
        foreach($child_list as $child) {
            $node_path_list_of_child = ConfigUtility::listAllNodePathVal($child);
            $node_path_list = array_merge($node_path_list, $node_path_list_of_child);
        }
        return $node_path_list;
    }
    public static function getPathVal($xml_path, $path_list) {
        $dom_doc = new DomDocument("1.0");
        $dom_doc->loadXML(file_get_contents($xml_path));
        $dom_xpath = new DOMXPath($dom_doc);
        $path_val_list = array();
        foreach($path_list as $path){
            $dom_node_list = $dom_xpath->query($path);
            $len = $dom_node_list->length;
            for($i = 0 ; $i < $len; $i++){
                $dom_element = $dom_node_list->item($i);
                $path_val_list = array_merge($path_val_list, ConfigUtility::listAllNodePathVal($dom_element));
            }
        }
        return $path_val_list;
    }
}